//=============================================================================
// SnowBall.
//=============================================================================
class SnowBall extends Containers;

event HitWall(vector HitNormal, actor HitWall)
{
	local float speed;

	Velocity = 0.8*((Velocity dot HitNormal) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
	speed = VSize(Velocity);
	bFixedRotationDir = True;
	RotationRate = RotRand(False);
	if ((speed > 0) && (speed < 30) && (HitNormal.Z > 0.7))
	{
		SetPhysics(PHYS_None, HitWall);
		if (Physics == PHYS_None)
			bFixedRotationDir = False;
	}
	else if (speed > 30)
	{
		PlaySound(None, SLOT_None);
		AISendEvent('LoudNoise', EAITYPE_Audio);
	}
}

defaultproperties
{
     numThings=5
     HitPoints=25
     FragType=Class'Markistan.SnowChunk'
     bFlammable=False
     ItemName="Snow ball"
     contents=Class'Markistan.Dollar'
     Texture=Texture'Markistan.Snow.SnowBallTex1'
     Skin=Texture'Markistan.Snow.SnowBallTex1'
     Mesh=LodMesh'DeusExDeco.Basketball'
     MultiSkins(0)=Texture'Markistan.Snow.SnowBallTex1'
     CollisionRadius=10.000000
     CollisionHeight=10.000000
     Mass=4.000000
     Buoyancy=10.000000
}
